package examples.hello;

import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.RMISecurityManager;
import java.rmi.server.UnicastRemoteObject;

public class HelloImpl extends UnicastRemoteObject
    implements Hello {

    public HelloImpl() throws RemoteException {
        super();
    }

    public String sayHello() {
        return  "Witaj wiecie!";
    }

    public static void main(String args[]) { 

        // Utworzenie i instalacja menedera zabezpiecze 
        if (System.getSecurityManager() == null) { 
	    System.setSecurityManager(new RMISecurityManager()); 
        } 
        try { 
	    HelloImpl obj = new HelloImpl(); 
	    // Powizanie tego egzemplarza obiektu z nazw "HelloServer" 
	    Naming.rebind("HelloServer", obj); 
	    System.out.println("HelloServer powizany w rejestrze"); 
        } catch (Exception e) { 
	    System.out.println("Bd HelloImpl : " + e.getMessage()); 
	    e.printStackTrace(); 
        } 
    } 
}
